<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms\Business\Brand;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\ListResource;
use Twilio\Rest\Preview\TrustedComms\Business\Brand\BrandedChannel\ChannelList;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 *
 * @property ChannelList $channels
 */
class BrandedChannelContext extends InstanceContext {
    protected $_channels;

    /**
     * Initialize the BrandedChannelContext
     *
     * @param Version $version Version that contains the resource
     * @param string $businessSid Business Sid.
     * @param string $brandSid Brand Sid.
     * @param string $sid Branded Channel Sid.
     */
    public function __construct(Version $version, $businessSid, $brandSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['businessSid' => $businessSid, 'brandSid' => $brandSid, 'sid' => $sid, ];

        $this->uri = '/Businesses/' . \rawurlencode($businessSid) . '/Brands/' . \rawurlencode($brandSid) . '/BrandedChannels/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the BrandedChannelInstance
     *
     * @return BrandedChannelInstance Fetched BrandedChannelInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): BrandedChannelInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new BrandedChannelInstance(
            $this->version,
            $payload,
            $this->solution['businessSid'],
            $this->solution['brandSid'],
            $this->solution['sid']
        );
    }

    /**
     * Access the channels
     */
    protected function getChannels(): ChannelList {
        if (!$this->_channels) {
            $this->_channels = new ChannelList(
                $this->version,
                $this->solution['businessSid'],
                $this->solution['brandSid'],
                $this->solution['sid']
            );
        }

        return $this->_channels;
    }

    /**
     * Magic getter to lazy load subresources
     *
     * @param string $name Subresource to return
     * @return ListResource The requested subresource
     * @throws TwilioException For unknown subresources
     */
    public function __get(string $name): ListResource {
        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown subresource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.TrustedComms.BrandedChannelContext ' . \implode(' ', $context) . ']';
    }
}